<?php

/**
 * Update options table with the specified data
 */
function update_options($data)
{
    global $conn; 

    $query = "UPDATE options SET option_value = CASE option_name ";
    foreach ($data as $key => $value) 
    {
        $query .= " WHEN '$key' THEN :$key ";
    }
    $query .= "END WHERE option_name IN ('" . implode("','", array_keys($data)) . "')";

    $sql = $conn->prepare($query);
    return ($sql->execute($data) ? true : false);
}


/**
 * Get list of Styles from the specified directory. 
 */
function get_styles($dir = array())
{
	$style_folders = glob($dir."*", GLOB_ONLYDIR);
	$styles = array();
	foreach ($style_folders as $row) 
	{
	  $styles[] = basename($row);
	}
	return $styles;
}

/**
 * Update a page content 
 */
function update_page($data, $id)
{
    global $conn; 

    $query = "UPDATE content SET ";
    foreach ($data as $key => $value) 
    {
        $query .= " $key=:$key, ";
    }
    $query = substr($query, 0, -2);
    $query .= " WHERE id=".$id ;

    $sql = $conn->prepare($query);
    return ($sql->execute($data) ? true : false);
}

/**
 * Create a new page
 */
function new_page($data)
{
    global $conn; 

    $query = "INSERT INTO content (";
    foreach ($data as $key => $value) 
    {
        $query .= "$key, ";
    }
    $query .= "date_created) VALUES (";

    foreach ($data as $key => $value) 
    {
        $query .= ":$key, ";
    }

    $query .= "NOW() )";

    $sql = $conn->prepare($query);
    return ($sql->execute($data) ? true : false);
}

/**
 * Delete a page
 */
function delete_page($id)
{
    global $conn; 

    $sql = $conn->prepare("DELETE FROM content WHERE id=".$id);
    return ($sql->execute($data) ? true : false);
}

function update_menu($data, $id)
{
    global $conn; 

    if (empty($data['menu_target'])) 
    {
        $data['menu_target'] = "false";
    }

    $query = "UPDATE menu SET ";
    foreach ($data as $key => $value) 
    {
        $query .= " $key=:$key, ";
    }
    $query = substr($query, 0, -2);
    $query .= " WHERE id=".$id ;

    $sql = $conn->prepare($query);
    return ($sql->execute($data) ? true : false);
}



function pagination($per_page = 10, $page = 1, $url = '', $total){

    $adjacents = "2";

    $page = ($page == 0 ? 1 : $page);
    $start = ($page - 1) * $per_page;

    $prev = $page - 1;
    $next = $page + 1;
    $lastpage = ceil($total/$per_page);
    $lpm1 = $lastpage - 1;

    $pagination = "";
    if($lastpage > 1)
    {
        $pagination .= "<ul>";
        $pagination .= "<li class='details'><p> &nbsp;Page $page of $lastpage<p></li>";
        if ($page > 1)
        {
            $pagination.= "<li><a href='{$url}1'>First</a></li>";
            $pagination.= "<li><a href='{$url}$prev'>Prev</a></li>";
        }
        else
        {
            $pagination.= "<li class='active'><a>First</a></li>";
            $pagination.= "<li class='active'><a>Prev</a></li>";
        }
        if ($lastpage < 7 + ($adjacents * 2))
        {
            for ($counter = 1; $counter <= $lastpage; $counter++)
            {

                if ($counter == $page)
                    $pagination.= "<li class='active'><a>$counter</a></li>";
                else
                    $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
            }
        }
        elseif($lastpage > 5 + ($adjacents * 2))  
        {
            if($page < 1 + ($adjacents * 2))
            {
                for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
                {
                    if ($counter == $page)
                        $pagination.= "<li class='active'><a>$counter</a></li>";
                    else
                        $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
                }
                $pagination.= "<li class='dot'><span>...</span></li>";
                $pagination.= "<li><a href='{$url}$lpm1'>$lpm1</a></li>";
                $pagination.= "<li><a href='{$url}$lastpage'>$lastpage</a></li>";
            }
            elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
            {
                $pagination.= "<li><a href='{$url}1'>1</a></li>";
                $pagination.= "<li><a href='{$url}2'>2</a></li>";
                $pagination.= "<li class='dot'><span>...</span></li>";
                for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
                {
                    if ($counter == $page)
                        $pagination.= "<li class='active'><a>$counter</a></li>";
                    else
                        $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
                }
                $pagination.= "<li class='dot'><span>..</span></li>";
                $pagination.= "<li><a href='{$url}$lpm1'>$lpm1</a></li>";
                $pagination.= "<li><a href='{$url}$lastpage'>$lastpage</a></li>";
            }
            else
            {
                $pagination.= "<li><a href='{$url}1'>1</a></li>";
                $pagination.= "<li><a href='{$url}2'>2</a></li>";
                $pagination.= "<li class='dot'><span>..</span></li>";
                for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
                {
                    if ($counter == $page)
                        $pagination.= "<li class='active'><a>$counter</a></li>";
                    else
                        $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
                }
            }
        }

        if ($page < $counter - 1)
        {
            $pagination.= "<li><a href='{$url}$next'>Next</a></li>";
             $pagination.= "<li><a href='{$url}$lastpage'>Last</a></li>";
        }
        else
        {
            $pagination.= "<li class='active'><a>Next</a></li>";
            $pagination.= "<li class='active'><a>Last</a></li>";
        }
        $pagination.= "</ul>\n";
    }
    return $pagination;
}



function update_site($domain)
{
    global $conn;
    global $globals;

    require '../lib/class.socialstats.php';
    require '../lib/class.analyzer.php';
    require '../lib/whois/whois.main.php';

    // Set some default veriables. 
    $data = array();

    // Get the domain to be reviewed
    $data['domain'] = $domain;

    // Get whois info 
    $whois = new Whois();
    $socialstats = new SocialStats('http://'.$data['domain']);
    $analyzer = new Analyzer($data['domain']);

    // get analyzer stats
    $analyzer_data = $analyzer->get_all();
    foreach ($analyzer_data as $key => $value) {
        $data[$key] = $value;
    }

    // get social stats
    $social_data = $socialstats->get_all();
    foreach ($social_data as $key => $value) {
        $data[$key] = $value;
    }

    $whois_data = $whois->Lookup($data['domain'],false);
    if(!isset($whois_data['regrinfo']['domain']['created']))
    {
        $data['domain_created'] = "Not Available";
    }
    else
    {
        $data['domain_created'] = $whois_data['regrinfo']['domain']['created'];
    }

    $whois_info = "";
    foreach($whois_data['rawdata'] as $key => $value){
        $whois_info .= $value."<br />";
    }
    $data['whois_info'] = $whois_info;

    
        $meta['title'] = get_title( 'http://'.$data['domain'] );

        $meta_data = get_meta_tags( 'http://'.$data['domain'] );
        $meta['description'] = (isset( $meta_data['description'] )) ? $meta_data['description'] : 'No description found';
        $meta['keywords'] = (isset( $meta_data['keywords'] )) ? $meta_data['keywords'] : 'No keywords found';

        $sql = $conn->query("INSERT INTO meta_data (domain, title, description, keywords) 
                    VALUES ('". $data['domain'] ."','". $meta['title'] ."','". $meta['description'] ."','". $meta['keywords']."') 
                    ON DUPLICATE KEY UPDATE title='". $meta['title'] ."', description='". $meta['description'] ."', keywords='". $meta['keywords'] ."' ");


    $data['updated'] = time();

    $update_sites = $conn->prepare($globals['update_query_sites']);
    return ($update_sites->execute($data) ? true : false);
}


function delete_site($id)
{
    global $conn; 

    $sql = $conn->prepare("DELETE FROM sites WHERE id=".$id);
    return ($sql->execute($data) ? true : false);
}